package com.volet.api.example;

import java.math.BigDecimal;

import com.volet.api.AuthDTO;
import com.volet.api.CheckCryptoCurrencyInvoiceResult;
import com.volet.api.CoinName;
import com.volet.api.CreateCryptoCurrencyInvoiceRequest;
import com.volet.api.CreateCryptoCurrencyInvoiceResult;
import com.volet.api.Currency;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.utils.AuthHelper;

public class CreateCryptoCurrencyInvoiceExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper.getAuthenticationToken("api_password"));

		try {
			CreateCryptoCurrencyInvoiceRequest arg1 = new CreateCryptoCurrencyInvoiceRequest();
			// `amount` or `cryptoCurrencyAmount` must be specified
			arg1.setAmount(BigDecimal.ONE.scaleByPowerOfTen(3));
//			arg1.setCryptoCurrencyAmount(BigDecimal.ONE);
			arg1.setCoinName(CoinName.BTC);
			arg1.setCurrency(Currency.USD);
			arg1.setSciName("sci_name");
			arg1.setOrderId("order_id");
			arg1.setNote("Note");

			CheckCryptoCurrencyInvoiceResult checkResult = mws.checkCryptoCurrencyInvoice(arg0, arg1);
			System.out.println(checkResult);

			CreateCryptoCurrencyInvoiceResult result = mws.createCryptoCurrencyInvoice(arg0, arg1);
			System.out.println(result);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}