package com.volet.api.example;

import java.math.BigDecimal;

import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.AuthDTO;
import com.volet.api.CryptoCurrencyWithdrawalInvoiceHolder;
import com.volet.api.Currency;
import com.volet.api.Ecurrency;
import com.volet.api.WithdrawToEcurrencyRequest;
import com.volet.api.utils.AuthHelper;

public class CryptoCurrencyWithdrawalInvoiceExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper.getAuthenticationToken("api_password"));

		WithdrawToEcurrencyRequest arg1 = new WithdrawToEcurrencyRequest();
		// arg1.setAmount(new BigDecimal("8000.00"));
		arg1.setCryptoCurrencyAmount(new BigDecimal("0.456321"));
		arg1.setCurrency(Currency.USD);
		arg1.setEcurrency(Ecurrency.BITCOIN);
		arg1.setReceiver("3GGeFcpTvbKcU9so2Fz4C8o4V2C9Du9Ngp");
		// arg1.setDestinationTag("777333999");
		arg1.setNote("Note");
		arg1.setOrderId("order_id");
		arg1.setDepositMethod("MASTERCARD");

		try {
			CryptoCurrencyWithdrawalInvoiceHolder dto = mws.createCryptoCurrencyWithdrawalInvoice(arg0, arg1);
			System.out.println(dto);

			dto = mws.findCryptoCurrencyWithdrawalInvoiceById(arg0, dto.getId());
			System.out.println(dto);

			dto = mws.findCryptoCurrencyWithdrawalInvoiceByOrderId(arg0, dto.getOrderId());
			System.out.println(dto);

			// ConfirmCryptoCurrencyWithdrawalInvoiceRequest request = new
			// ConfirmCryptoCurrencyWithdrawalInvoiceRequest();
			// request.setInvoiceId(dto.getId());
			// String transactionId =
			// mws.confirmCryptoCurrencyWithdrawalInvoice(arg0, request);
			// System.out.println(transactionId);
			//
			// dto = mws.findCryptoCurrencyWithdrawalInvoiceById(arg0,
			// dto.getId());
			// System.out.println(dto);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}