package com.volet.api.example;

import java.math.BigDecimal;

import com.volet.api.AuthDTO;
import com.volet.api.CheckCurrencyExchangeRequest;
import com.volet.api.Currency;
import com.volet.api.CurrencyExchangeAction;
import com.volet.api.CurrencyExchangeRequest;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.utils.AuthHelper;

public class CurrencyExchangeExample {

	public static void main(String[] args) throws Exception {
		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		CurrencyExchangeRequest arg1 = new CurrencyExchangeRequest();
		arg1.setFrom(Currency.USD);
		arg1.setTo(Currency.EUR);
		arg1.setAction(CurrencyExchangeAction.SELL);
		arg1.setAmount(BigDecimal.ONE);
		arg1.setNote("note");

		CheckCurrencyExchangeRequest arg4 = new CheckCurrencyExchangeRequest();
		arg4.setFrom("USD");
		arg4.setTo("BTC");
		arg4.setAction(CurrencyExchangeAction.SELL);
		arg4.setAmount(BigDecimal.ONE.movePointRight(3));

		try {
			System.out.println(mws.checkCurrencyExchange(arg0, arg4));
			mws.validationCurrencyExchange(arg0, arg1);
			String tansactionID = mws.currencyExchange(arg0, arg1);
			System.out.println("New transaction with id " + tansactionID + " has been created");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}