package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.PaymentOrderRequest;
import com.volet.api.PaymentOrderResultHolder;
import com.volet.api.utils.AuthHelper;

public class FindPaymentByOrderIdExample {

	public static void main(String[] args) throws Exception {
		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper.getAuthenticationToken("api_password"));

		PaymentOrderRequest arg1 = new PaymentOrderRequest();
		arg1.setSciName("sci_name");
		arg1.setOrderId("order_id");

		try {
			PaymentOrderResultHolder paymentOrderResult = mws.findPaymentByOrderId(arg0, arg1);
			System.out.println(paymentOrderResult);
			System.out.println(paymentOrderResult.getPaymentStatus());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}