package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.ApiTransactionDTO;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.utils.AuthHelper;

public class FindTransactionExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service
				.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		String arg1 = "ef2ac711-407f-4736-b596-17b5913765dd";

		try {
			ApiTransactionDTO transaction = mws.findTransaction(arg0,
					arg1);
			if (transaction != null) {
				System.out.println(transaction.getId() + " : "
						+ transaction.getComment() + " : "
						+ transaction.getStartTime().getTime() + " : "
						+ transaction.getStatus() + " : "
						+ transaction.getTransactionName() + " : "
						+ transaction.isSci() + " : "
						+ transaction.getWalletSrcId() + " : "
						+ transaction.getWalletDestId() + " : "
						+ transaction.getSenderEmail() + " : "
						+ transaction.getReceiverEmail() + " : "
						+ transaction.getAmount() + " : "
						+ transaction.getCurrency() + " : "
						+ transaction.getFullCommission() + " : "
						+ transaction.getDirection() + " : "
						+ transaction.getOrderId());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}