package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.APITransactionFilter;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.ApiTransactionDTO;
import com.volet.api.SortOrder;
import com.volet.api.TransactionStatus;
import com.volet.api.utils.AuthHelper;
import com.volet.api.utils.DateConverter;

public class HistoryExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		APITransactionFilter arg1 = new APITransactionFilter();
		arg1.setFrom(10);
		arg1.setCount(5);
		arg1.setSortOrder(SortOrder.ASC);
		arg1.setStartTimeFrom(DateConverter.stringToCalendar("2011-09-05T20:32:11"));
		arg1.setStartTimeTo(DateConverter.stringToCalendar("2013-12-05T20:59:00"));
		arg1.setTransactionName("INNER_SYSTEM");
		arg1.setTransactionStatus(TransactionStatus.PENDING);
		arg1.setWalletId("U112983230977");

		try {
			ApiTransactionDTO[] transactions = mws.history(arg0, arg1);
			if (transactions != null) {
				for (ApiTransactionDTO transaction : transactions) {
					System.out.println(transaction.getId() + " : "
							+ transaction.getComment() + " : "
							+ transaction.getStartTime().getTime() + " : "
							+ transaction.getStatus() + " : "
							+ transaction.getTransactionName() + " : "
							+ transaction.isSci() + " : "
							+ transaction.getWalletSrcId() + " : "
							+ transaction.getWalletDestId() + " : "
							+ transaction.getSenderEmail() + " : "
							+ transaction.getReceiverEmail() + " : "
							+ transaction.getAmount() + " : "
							+ transaction.getCurrency() + " : "
							+ transaction.getFullCommission() + " : "
							+ transaction.getDirection() + " : "
							+ transaction.getOrderId());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}