package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.CoinName;
import com.volet.api.Currency;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.MinLimitsForCryptoTxsRequest;
import com.volet.api.TransactionDirection;
import com.volet.api.utils.AuthHelper;

public class MinLimitsForCryptoTxsExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper.getAuthenticationToken("api_password"));

		MinLimitsForCryptoTxsRequest arg1 = new MinLimitsForCryptoTxsRequest(CoinName.BTC, false,
				TransactionDirection.INCOMING, Currency.USD);

		try {
			System.out.println(mws.getMinLimitsForCryptoTxs(arg0, arg1));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}