package com.volet.api.example;

import java.math.BigDecimal;

import com.volet.api.AuthDTO;
import com.volet.api.Currency;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.P2POrderDTO;
import com.volet.api.P2POrderRequest;
import com.volet.api.utils.AuthHelper;

public class P2pOrderExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper.getAuthenticationToken("api_password"));

		final String orderId = "123456";

		P2POrderRequest request = new P2POrderRequest();
		request.setAmount(BigDecimal.TEN);
		request.setCurrency(Currency.USD);
		request.setOrderId(orderId);
		request.setReceiver("name@example.com");
		request.setRedirectUrl("https://site.com/redirect");
		request.setCallbackUrl("https://site.com/callback");

		P2POrderDTO order;
		try {
			order = mws.createP2POrder(arg0, request);
			order = mws.findP2POrderByOrderId(arg0, orderId);
//			order = mws.cancelP2POrderByOrderId(arg0, orderId);
			System.out.println(order);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}