package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.RegistrationRequest;
import com.volet.api.SupportedLanguage;
import com.volet.api.utils.AuthHelper;

public class RegisterExample {

	public static void main(String[] args) throws Exception {
		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service
				.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		RegistrationRequest arg1 = new RegistrationRequest();
		arg1.setEmail("email");
		arg1.setFirstName("firstName");
		arg1.setLastName("lastName");
		arg1.setLanguage(SupportedLanguage.en);
		arg1.setIp("*.*.*.*");

		try {
			mws.register(arg0, arg1);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}