package com.volet.api.example;

import com.volet.api.AuthDTO;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.ValidateAccountRequestDTO;
import com.volet.api.ValidateAccountResultDTO;
import com.volet.api.utils.AuthHelper;

public class ValidateAccountExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service
				.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		ValidateAccountRequestDTO arg1 = new ValidateAccountRequestDTO();
		arg1.setWalletId("wallet_id");
		// arg1.setEmail("email");
		arg1.setFirstName("first");
		arg1.setLastName("last");

		try {
			ValidateAccountResultDTO result = mws.validateAccount(arg0, arg1);
			System.out.println(result.getEmail());
			System.out.println(result.getWalletId());
			System.out.println(result.getFirstName());
			System.out.println(result.getLastName());
			System.out.println(result.getFirstNameMatchingPercentage());
			System.out.println(result.getLastNameMatchingPercentage());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}