package com.volet.api.example;

import com.volet.api.AccountPresentDTO;
import com.volet.api.AuthDTO;
import com.volet.api.ApiWebService_PortType;
import com.volet.api.ApiWebService_Service;
import com.volet.api.ApiWebService_ServiceLocator;
import com.volet.api.utils.AuthHelper;

public class ValidateAccountsExample {

	public static void main(String[] args) throws Exception {

		ApiWebService_Service mws_service = new ApiWebService_ServiceLocator();
		ApiWebService_PortType mws = mws_service
				.getApiWebServicePort();

		AuthDTO arg0 = new AuthDTO();
		arg0.setApiName("api_name");
		arg0.setAccountEmail("account_email");
		arg0.setAuthenticationToken(AuthHelper
				.getAuthenticationToken("api_password"));

		String[] arg1 = new String[] { "user_email" };

		try {
			AccountPresentDTO[] accounts = mws.validateAccounts(arg0, arg1);
			for (AccountPresentDTO account : accounts) {
				System.out.println(account.getSystemAccountName() + " : "
						+ account.getPresent());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}