<?php
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Uri\Uri;

class plgVmpaymentVoletpayment extends vmPlugin
{
    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        $this->_loggable = true;
        $this->_tablepkey = 'id';
        $this->_tableId = 'id';
        $this->setConfigParameterable(['basic'], [
            'title', 'description', 'email', 'sci_name', 'secret_key',
            'success_url', 'fail_url', 'status_url'
        ]);
    }

    function plgVmConfirmedOrder($cart, $order)
    {
        $payment_params = $this->getPluginMethods($cart->virtuemart_paymentmethod_id);
        $method = $payment_params[0];

        $sci_name = $method->sci_name;
        $secret_key = $method->secret_key;
        $email = $method->email;
        $status_url = $method->status_url;
        $success_url = $method->success_url;
        $fail_url = $method->fail_url;

        $order_number = $order['details']['BT']->order_number;
        $amount = $order['details']['BT']->order_total;
        $currency = $order['details']['BT']->order_currency;

        $form = '<form action="' . htmlspecialchars($status_url) . '" method="post" name="vm_volet_form">';
        $form .= '<input type="hidden" name="email" value="' . htmlspecialchars($email) . '" />';
        $form .= '<input type="hidden" name="sci_name" value="' . htmlspecialchars($sci_name) . '" />';
        $form .= '<input type="hidden" name="order_id" value="' . htmlspecialchars($order_number) . '" />';
        $form .= '<input type="hidden" name="amount" value="' . htmlspecialchars($amount) . '" />';
        $form .= '<input type="hidden" name="currency" value="' . htmlspecialchars($currency) . '" />';
        $form .= '<input type="hidden" name="success_url" value="' . htmlspecialchars($success_url) . '" />';
        $form .= '<input type="hidden" name="fail_url" value="' . htmlspecialchars($fail_url) . '" />';
        $form .= '<input type="submit" class="button" value="Pay with Volet" />';
        $form .= '</form>';

        return array('html' => $form);
    }

    function plgVmOnPaymentResponseReceived(&$html)
    {
        JLog::add('Volet Payment: response received', JLog::INFO, 'voletpayment');
        return true;
    }

    function plgVmDeclarePluginParamsPaymentVM3(&$data)
    {
        return true;
    }

    function plgVmSetOnTablePluginParamsPayment(&$data, $table)
    {
        return true;
    }
}
