<?php
/**
 * Plugin Name: Volet.com SCI for WooCommerce
 * Plugin URI: https://Volet.com
 * Volet.com SCI: Custom Volet.com Payment Gateway for WooCommerce
 * Version: 2.4.0
 * Author: Volet.com
 * Author URI: https://Volet.com
 */

if (!defined('ABSPATH')) {
    exit;
}

add_filter('woocommerce_payment_gateways', 'add_volet_payment_gateway');
function add_volet_payment_gateway($gateways)
{
    $gateways[] = 'WC_Volet_Gateway';
    return $gateways;
}

add_action('plugins_loaded', 'init_volet_payment_gateway');

function init_volet_payment_gateway()
{
    if (!class_exists('WC_Payment_Gateway')) return;

    class WC_Volet_Gateway extends WC_Payment_Gateway
    {
        public function __construct()
        {
            $this->id = 'volet';
            $this->icon = plugins_url('icon.png', __FILE__);
            $this->has_fields = false;
            $this->method_title = 'Volet.com SCI';
            $this->method_description = 'Payment Gateway Volet.com SCI';

            $this->init_form_fields();
            $this->init_settings();

            $this->title = $this->get_option('title');
            $this->description = $this->get_option('description');
            $this->email = $this->get_option('email');
            $this->sci_name = $this->get_option('sci_name');
            $this->secret_key = $this->get_option('secret_key');
            $this->success_url = $this->get_option('success_url');
            $this->fail_url = $this->get_option('fail_url');
            $this->status_url = $this->get_option('status_url');

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
        }

        public function init_form_fields()
        {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => 'Enable/Disable',
                    'type' => 'checkbox',
                    'label' => 'Enable Volet.com',
                    'default' => 'yes'
                ),
                'title' => array(
                    'title' => 'Name',
                    'type' => 'text',
                    'default' => 'Payment via Volet.com'
                ),
                'description' => array(
                    'title' => 'Description',
                    'type' => 'textarea',
                    'default' => 'Make payment quickly and safe via Volet.com'
                ),
                'email' => array(
                    'title' => 'Volet.com Email',
                    'type' => 'text',
                    'default' => ''
                ),
                'sci_name' => array(
                    'title' => 'SCI Name',
                    'type' => 'text',
                    'default' => ''
                ),
                'secret_key' => array(
                    'title' => 'Secret Key',
                    'type' => 'password',
                    'default' => ''
                ),
                'success_url' => array(
                    'title' => 'URL success',
                    'type' => 'text',
                    'default' => home_url('/order-received/')
                ),
                'fail_url' => array(
                    'title' => 'URL failure',
                    'type' => 'text',
                    'default' => home_url('/checkout/')
                ),
                'status_url' => array(
                    'title' => 'URL payment status',
                    'type' => 'text',
                    'default' => home_url('/?wc-api=wc_volet_callback')
                )
            );
        }

        public function process_payment($order_id)
        {
            $order = wc_get_order($order_id);
            $amount = $order->get_total();
            $currency = get_woocommerce_currency();
            $email = $this->get_option('email'); 
            $sci_name = $this->get_option('sci_name'); 
            $secret_key = $this->get_option('secret_key');
            $success_url = $this->get_option('success_url');
            $fail_url = $this->get_option('fail_url');
            $status_url = $this->get_option('status_url');
            $order_id = $order->get_id();

            if (empty($email) || empty($sci_name) || empty($amount) || empty($currency) || empty($order_id) || empty($secret_key)) {
                wc_add_notice(__('Error: Miss some params Volet.com!', 'woocommerce'), 'error');
                return array('result' => 'failure');
            }

            // Формируем ac_sign в правильном порядке
            $sign_string = $email . ":" . $sci_name . ":" . number_format($amount, 2, '.', '') . ":" . $currency . ":" . $secret_key . ":" . $order_id;
            $ac_sign = hash('sha256', $sign_string);

            // Формируем URL для редиректа
            $redirect_url = 'https://account.volet.com/sci/?' . http_build_query([
                'ac_account_email' => $email,
                'ac_sci_name' => $sci_name,
                'ac_amount' => $amount,
                'ac_currency' => $currency,
                'ac_order_id' => $order_id,
                'ac_success_url' => $success_url,
                'ac_fail_url' => $fail_url,
                'ac_status_url' => $status_url,
                'ac_sign' => $ac_sign
            ]);

            return array(
                'result'   => 'success',
                'redirect' => $redirect_url,
            );
        }
    }
}
